; Set up display:
Graphics 800,600

; Set window title (for when we're back to the Windows desktop):
AppTitle "George says 'Baa'..."

; Load images:
Global bgd	=	LoadImage ("background.bmp")	; background

Global geo	=	LoadImage ("george.bmp")		; George normal
Global geo2	=	LoadImage ("george2.bmp")		; George frame 2
Global geo3	=	LoadImage ("george3.bmp")		; George frame 3
Global geo4	=	LoadImage ("george4.bmp")		; George frame 4

Global sun	=	LoadImage ("sun.bmp")			; The Sun normal
Global sun2	=	LoadImage ("sun2.bmp")			; Sun frame 2

Global bsh	=	LoadImage ("bush.bmp")			; Bush normal
Global bsh2	=	LoadImage ("bush2.bmp")			; Bush frame 2
Global bsh3	=	LoadImage ("bush3.bmp")			; Bush frame 3
Global bsh4	=	LoadImage ("bush4.bmp")			; Bush frame 4

; Load sounds:
baa			=	LoadSound ("baa.wav")			; Baa
scream		=	LoadSound ("scream.wav")		; Aaa
burn		=	LoadSound ("burn.wav")			; Hot!

; Set up image transparency masks (ie background colour will be see-through):
MaskImage geo,32,96,96
MaskImage geo2,32,96,96
MaskImage geo3,32,96,96
MaskImage geo4,32,96,96

MaskImage sun,32,96,96

MaskImage bsh,32,96,96
MaskImage bsh2,32,96,96
MaskImage bsh3,32,96,96
MaskImage bsh4,32,96,96

; Some variables:
Global gx=200:Global gy=440						; George's position
Global score=0									; Score...ahem...

SetFont LoadFont ("Arial",48,1)					; Load a big font

; The double buffering routine:
Function Update (george,bush)
	Cls											; Clear the back buffer
	DrawImage bgd,0,0							; Draw background to it
	DrawImage george,gx,gy						; Draw George
	DrawImage bush,400,440						; Draw George's bush (ha ha in a couple of ways, yes?)
	DrawImage sun,MouseX (),MouseY ()			; Draw Sun
	Color 0,0,0:Text 500,20,"Score:"+score		; Draw score
	Color 255,255,255:Text 498,18,"Score:"+score; ----""----
	Flip										; Bring back buffer we just drew on to front
End Function

; We'll be drawing to the back buffer, always (it gets flipped to the front by Update ()):
SetBuffer BackBuffer ()

; Main loop:
Repeat

	If Rnd (500000)>495550 Then PlaySound baa	; Bit dodgy...play "Baa" at random intervals

	sc=0										; Used to tell if sound has already played (eg scream)

; Image collision:

	; Sun hits George:
	While ImagesCollide (geo,gx,gy,0,sun,MouseX (), MouseY (),0)
		If sc=0 Then SoundPitch scream, Rnd(40000,50000):PlaySound scream:sc=1	; Screamed
		If a=0 Then a=MilliSecs ()												; Timer for frames
		george=geo																; Choose image...
		If MilliSecs()-a>50 Then george=geo2									; ...to show...
		If MilliSecs()-a>100 Then george=geo3									; ...depending...
		If MilliSecs()-a>150 Then george=geo4									; ...on timer.
		If MilliSecs()-a>200 Then a=0											; Reset timer
		gx=gx+Rnd (-4,4)														; Jumpy George!
		gy=gy+Rnd (-1,1)														; And again!
		score=score+1															; Update score
		Update (george,bsh)														; Draw result
	Wend

	sc=0										; Same as up there ^^^ !

; Image collision:

	; Sun hits bush:
	While ImagesCollide (bsh,400,440,0,sun,MouseX (), MouseY (),0)
		If sc=0 Then PlaySound burn:sc=1
		If a=0 Then a=MilliSecs ()
		bush=bsh
		If MilliSecs()-a>100 Then bush=bsh2
		If MilliSecs()-a>200 Then bush=bsh3
		If MilliSecs()-a>300 Then bush=bsh4:a=0
		Update (geo,bush)
	Wend

; Main loop image update:
	Update (geo,bsh)

Until KeyDown (1)=1								; [ESC] hit

End